package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.objects.martialarts.Maneuver;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CustomManeuverDialog extends GenericDialog {
	private static final long serialVersionUID = -395942732698168110L;

	protected Maneuver maneuver;

	private JLabel phaseLbl;

	JComboBox phaseCombo;

	private JLabel ocvLbl;

	LevelTF ocvTF;

	private JLabel dcvLbl;

	LevelTF dcvTF;

	private JLabel rangeLbl;

	LevelTF rangeTF;

	private JLabel damageTypeLbl;
	private JComboBox damageTypeCombo;
	private JLabel dcLbl;
	private LevelTF dcTF;

	private JLabel rangeInstructions;

	private JLabel effectLbl;
	private JLabel effectInstructionsLbl;

	JTextField effectTF;

	private JLabel typeLbl;

	JComboBox typeCombo;

	private JLabel effectiveActiveCostLbl;
	private LevelTF effectiveActiveCostTF;

	public CustomManeuverDialog(Maneuver pk, boolean isNew, boolean isPower) {
		super(pk, isNew, isPower);
		maneuver = pk;
		init();
		extrasPanel.setVisible(false);
		extrasScroll.setVisible(false);
		customAdderBtn.setVisible(false);
		addModifierBtn.setVisible(false);
		pack();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();

		gbc.gridx = 0;
		gbc.gridy = 22;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		panel.add(typeLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(typeCombo, gbc);

		gbc.gridx = 0;
		gbc.gridy = 31;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		panel.add(effectiveActiveCostLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(effectiveActiveCostTF, gbc);

		gbc.gridx = 0;
		gbc.gridy = 41;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(phaseLbl, gbc);
		gbc.gridy = 42;
		panel.add(ocvLbl, gbc);
		gbc.gridy = 43;
		panel.add(dcvLbl, gbc);
		gbc.gridy = 44;
		panel.add(rangeLbl, gbc);
		gbc.gridy = 45;
		panel.add(damageTypeLbl, gbc);
		gbc.gridy = 46;
		panel.add(dcLbl, gbc);
		gbc.gridy = 47;
		panel.add(effectLbl, gbc);
		gbc.gridy = 41;
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(phaseCombo, gbc);
		gbc.gridy = 42;
		panel.add(ocvTF, gbc);
		gbc.gridy = 43;
		panel.add(dcvTF, gbc);
		gbc.gridy = 44;
		panel.add(rangeTF, gbc);
		gbc.gridx = 2;
		panel.add(rangeInstructions, gbc);
		gbc.gridx = 1;
		gbc.gridy = 45;
		gbc.gridwidth = 2;
		panel.add(damageTypeCombo, gbc);
		gbc.gridy = 46;
		panel.add(dcTF, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridy = 47;
		panel.add(effectTF, gbc);
		gbc.gridy = 48;
		panel.add(effectInstructionsLbl, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		typeCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				maneuver.setUseWeapon(typeCombo.getSelectedIndex() == 1);

				updateValues();
			}
		});
		damageTypeCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				maneuver.setDamageType(damageTypeCombo.getSelectedIndex());
				updateValues();
			}
		});
		phaseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				maneuver.setPhase(phaseCombo.getSelectedItem().toString());
			}
		});
		effectiveActiveCostTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						int val = effectiveActiveCostTF.getCurrent();
						maneuver.setManeuverActiveCost(val);
						updateValues();
					}
				});
		dcTF.addPropertyChangeListener("Level", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				int val = dcTF.getCurrent();
				maneuver.setDC(val);
			}
		});
		ocvTF.addPropertyChangeListener("Level", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				int val = ocvTF.getCurrent();
				String set = "" + val;
				if (val >= 0) {
					set = "+" + set;
				}
				maneuver.setOCV(set);
			}
		});
		dcvTF.addPropertyChangeListener("Level", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				int val = dcvTF.getCurrent();
				String set = "" + val;
				if (val >= 0) {
					set = "+" + set;
				}
				maneuver.setDCV(set);
			}
		});
		rangeTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						maneuver.setRanged(rangeTF.getCurrent());
					}
				});
		effectTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				maneuver.setEffect(effectTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				maneuver.setEffect(effectTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				maneuver.setEffect(effectTF.getText());
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		pointsLbl.setText("Cost:");
		effectiveActiveCostLbl = new JLabel("Maneuver Active Cost:");
		effectiveActiveCostTF = new LevelTF(maneuver.getManeuverActiveCost(),
				999, 0);
		phaseLbl = new JLabel("Phase:");
		ArrayList<String> vec = new ArrayList<String>();
		vec.add("1/2");
		vec.add("1");
		vec.add("1+1");
		vec.add("var.");
		phaseCombo = new JComboBox(vec.toArray());
		phaseCombo.setSelectedItem(maneuver.getPhase());
		ocvLbl = new JLabel("OCV:");
		ocvTF = new LevelTF(maneuver.getOCVValue(), 10, -10);
		dcvLbl = new JLabel("DCV:");
		dcvTF = new LevelTF(maneuver.getDCVValue(), 10, -10);
		rangeLbl = new JLabel("Range:");
		rangeTF = new LevelTF(maneuver.getRanged(), 10, -1);
		rangeInstructions = new JLabel("Use -1 for No Range");

		damageTypeLbl = new JLabel("Damage Type:");
		dcLbl = new JLabel("DCs:");
		vec = new ArrayList<String>();
		vec.add("None/Non-Damaging");
		vec.add("STR/Exert");
		vec.add("Normal Damage");
		vec.add("Killing Damage");
		vec.add("NND");
		vec.add("Flash");
		damageTypeCombo = new JComboBox(vec.toArray());
		damageTypeCombo.setSelectedIndex(maneuver.getDamageType());

		dcTF = new LevelTF(maneuver.getDC(), 4, 0);
		effectLbl = new JLabel("Effect:");
		effectTF = new JTextField(maneuver.getEffect());
		effectInstructionsLbl = new JLabel(
				"[DAMAGE] will insert the maneuver's damage total at the specified point");

		typeLbl = new JLabel("Type");
		vec = new ArrayList<String>();
		vec.add("Empty Hand");
		vec.add("Weapon");
		typeCombo = new JComboBox(vec.toArray());
		if (maneuver.useWeapon()) {
			typeCombo.setSelectedIndex(1);
		}

		setNameVisible(false);
	}

	@Override
	public void updateValues() {
		super.updateValues();
		addModifierBtn.setVisible(maneuver.allowsOtherModifiers());
		if (maneuver.useWeapon()) {
			damageTypeLbl.setVisible(false);
			damageTypeCombo.setVisible(false);
		} else {
			damageTypeLbl.setVisible(true);
			damageTypeCombo.setVisible(true);
		}
	}

}